/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;

public class DirectoryWalkerTestCaseJava4
extends TestCase {
    private static final File current = new File(".");
    private static final File javaDir = new File("src/main/java");
    private static final File orgDir = new File(javaDir, "org");
    private static final File apacheDir = new File(orgDir, "apache");
    private static final File commonsDir = new File(apacheDir, "commons");
    private static final File ioDir = new File(commonsDir, "io");
    private static final File outputDir = new File(ioDir, "output");
    private static final File[] dirs = new File[]{orgDir, apacheDir, commonsDir, ioDir, outputDir};
    private static final File filenameUtils = new File(ioDir, "FilenameUtils.java");
    private static final File ioUtils = new File(ioDir, "IOUtils.java");
    private static final File proxyWriter = new File(outputDir, "ProxyWriter.java");
    private static final File nullStream = new File(outputDir, "NullOutputStream.java");
    private static final File[] ioFiles = new File[]{filenameUtils, ioUtils};
    private static final File[] outputFiles = new File[]{proxyWriter, nullStream};
    private static final IOFileFilter dirsFilter = DirectoryWalkerTestCaseJava4.createNameFilter(dirs);
    private static final IOFileFilter iofilesFilter = DirectoryWalkerTestCaseJava4.createNameFilter(ioFiles);
    private static final IOFileFilter outputFilesFilter = DirectoryWalkerTestCaseJava4.createNameFilter(outputFiles);
    private static final IOFileFilter ioDirAndFilesFilter = new OrFileFilter(dirsFilter, iofilesFilter);
    private static final IOFileFilter dirsAndFilesFilter = new OrFileFilter(ioDirAndFilesFilter, outputFilesFilter);
    private static final IOFileFilter NOT_SVN = FileFilterUtils.makeSVNAware(null);

    public DirectoryWalkerTestCaseJava4(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFilter() {
        List results = new TestFileFinder((FileFilter)dirsAndFilesFilter, -1).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"Result Size", (int)(1 + dirs.length + ioFiles.length + outputFiles.length), (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("Dir", dirs, results);
        this.checkContainsFiles("IO File", ioFiles, results);
        this.checkContainsFiles("Output File", outputFiles, results);
    }

    public void testFilterAndLimitA() {
        List results = new TestFileFinder((FileFilter)NOT_SVN, 0).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[A] Result Size", (int)1, (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[A] Start Dir", (boolean)results.contains(javaDir));
    }

    public void testFilterAndLimitB() {
        List results = new TestFileFinder((FileFilter)NOT_SVN, 1).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[B] Result Size", (int)2, (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[B] Start Dir", (boolean)results.contains(javaDir));
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[B] Org Dir", (boolean)results.contains(orgDir));
    }

    public void testFilterAndLimitC() {
        List results = new TestFileFinder((FileFilter)NOT_SVN, 3).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[C] Result Size", (int)4, (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[C] Start Dir", (boolean)results.contains(javaDir));
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[C] Org Dir", (boolean)results.contains(orgDir));
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[C] Apache Dir", (boolean)results.contains(apacheDir));
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[C] Commons Dir", (boolean)results.contains(commonsDir));
    }

    public void testFilterAndLimitD() {
        List results = new TestFileFinder((FileFilter)dirsAndFilesFilter, 5).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[D] Result Size", (int)(1 + dirs.length + ioFiles.length), (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[D] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[D] Dir", dirs, results);
        this.checkContainsFiles("[D] File", ioFiles, results);
    }

    public void testFilterDirAndFile1() {
        List results = new TestFileFinder(dirsFilter, iofilesFilter, -1).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[DirAndFile1] Result Size", (int)(1 + dirs.length + ioFiles.length), (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[DirAndFile1] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile1] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile1] File", ioFiles, results);
    }

    public void testFilterDirAndFile2() {
        List results = new TestFileFinder(null, null, -1).find(javaDir);
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[DirAndFile2] Result Size", (results.size() > 1 + dirs.length + ioFiles.length ? 1 : 0) != 0);
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[DirAndFile2] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile2] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile2] File", ioFiles, results);
    }

    public void testFilterDirAndFile3() {
        List results = new TestFileFinder(dirsFilter, null, -1).find(javaDir);
        List resultDirs = this.directoriesOnly(results);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[DirAndFile3] Result Size", (int)(1 + dirs.length), (int)resultDirs.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[DirAndFile3] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile3] Dir", dirs, resultDirs);
    }

    public void testFilterDirAndFile4() {
        List results = new TestFileFinder(null, iofilesFilter, -1).find(javaDir);
        List resultFiles = this.filesOnly(results);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"[DirAndFile4] Result Size", (int)ioFiles.length, (int)resultFiles.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"[DirAndFile4] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile4] File", ioFiles, resultFiles);
    }

    public void testLimitToCurrent() {
        List results = new TestFileFinder(null, 0).find(current);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"Result Size", (int)1, (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"Current Dir", (boolean)results.contains(new File(".")));
    }

    public void testMissingStartDirectory() {
        File invalidDir = new File("invalid-dir");
        List results = new TestFileFinder(null, -1).find(invalidDir);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"Result Size", (int)1, (int)results.size());
        DirectoryWalkerTestCaseJava4.assertTrue((String)"Current Dir", (boolean)results.contains(invalidDir));
        try {
            new TestFileFinder(null, -1).find(null);
            DirectoryWalkerTestCaseJava4.fail((String)"Null start directory didn't throw Exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHandleStartDirectoryFalse() {
        List results = new TestFalseFileFinder(null, -1).find(current);
        DirectoryWalkerTestCaseJava4.assertEquals((String)"Result Size", (int)0, (int)results.size());
    }

    private void checkContainsFiles(String prefix, File[] files, Collection results) {
        for (int i = 0; i < files.length; ++i) {
            DirectoryWalkerTestCaseJava4.assertTrue((String)(prefix + "[" + i + "] " + files[i]), (boolean)results.contains(files[i]));
        }
    }

    private List directoriesOnly(Collection results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        return list;
    }

    private List filesOnly(Collection results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isFile()) continue;
            list.add(file);
        }
        return list;
    }

    private static IOFileFilter createNameFilter(File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName();
        }
        return new NameFileFilter(names);
    }

    public void testCancel() {
        String cancelName = null;
        try {
            cancelName = "DirectoryWalker.java";
            new TestCancelWalker(cancelName, false).find(javaDir);
            DirectoryWalkerTestCaseJava4.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            DirectoryWalkerTestCaseJava4.assertEquals((String)("File:  " + cancelName), (String)cancelName, (String)cancel.getFile().getName());
            DirectoryWalkerTestCaseJava4.assertEquals((String)("Depth: " + cancelName), (int)5, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCaseJava4.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            cancelName = "commons";
            new TestCancelWalker(cancelName, false).find(javaDir);
            DirectoryWalkerTestCaseJava4.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            DirectoryWalkerTestCaseJava4.assertEquals((String)("File:  " + cancelName), (String)cancelName, (String)cancel.getFile().getName());
            DirectoryWalkerTestCaseJava4.assertEquals((String)("Depth: " + cancelName), (int)3, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCaseJava4.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            List results = new TestCancelWalker(cancelName, true).find(javaDir);
            File lastFile = (File)results.get(results.size() - 1);
            DirectoryWalkerTestCaseJava4.assertEquals((String)("Suppress:  " + cancelName), (String)cancelName, (String)lastFile.getName());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCaseJava4.fail((String)("Suppress threw " + ex));
        }
    }

    public void testMultiThreadCancel() {
        String cancelName = "DirectoryWalker.java";
        TestMultiThreadCancelWalker walker = new TestMultiThreadCancelWalker(cancelName, false);
        try {
            walker.find(javaDir);
            DirectoryWalkerTestCaseJava4.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            File last = (File)walker.results.get(walker.results.size() - 1);
            DirectoryWalkerTestCaseJava4.assertEquals((String)cancelName, (String)last.getName());
            DirectoryWalkerTestCaseJava4.assertEquals((String)("Depth: " + cancelName), (int)5, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCaseJava4.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            cancelName = "commons";
            walker = new TestMultiThreadCancelWalker(cancelName, false);
            walker.find(javaDir);
            DirectoryWalkerTestCaseJava4.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            DirectoryWalkerTestCaseJava4.assertEquals((String)("File:  " + cancelName), (String)cancelName, (String)cancel.getFile().getName());
            DirectoryWalkerTestCaseJava4.assertEquals((String)("Depth: " + cancelName), (int)3, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCaseJava4.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            walker = new TestMultiThreadCancelWalker(cancelName, true);
            List results = walker.find(javaDir);
            File lastFile = (File)results.get(results.size() - 1);
            DirectoryWalkerTestCaseJava4.assertEquals((String)("Suppress:  " + cancelName), (String)cancelName, (String)lastFile.getName());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCaseJava4.fail((String)("Suppress threw " + ex));
        }
    }

    static class TestMultiThreadCancelWalker
    extends DirectoryWalker {
        private String cancelFileName;
        private boolean suppressCancel;
        private boolean cancelled;
        public List results;

        TestMultiThreadCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List find(File startDirectory) throws IOException {
            this.results = new ArrayList();
            this.walk(startDirectory, this.results);
            return this.results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) throws IOException {
            results.add(directory);
            Assert.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(directory.getName())) {
                this.cancelled = true;
            }
        }

        protected void handleFile(File file, int depth, Collection results) throws IOException {
            results.add(file);
            Assert.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(file.getName())) {
                this.cancelled = true;
            }
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            return this.cancelled;
        }

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }
    }

    static class TestCancelWalker
    extends DirectoryWalker {
        private String cancelFileName;
        private boolean suppressCancel;

        TestCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List find(File startDirectory) throws IOException {
            ArrayList results = new ArrayList();
            this.walk(startDirectory, results);
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) throws IOException {
            results.add(directory);
            if (this.cancelFileName.equals(directory.getName())) {
                throw new DirectoryWalker.CancelException(directory, depth);
            }
        }

        protected void handleFile(File file, int depth, Collection results) throws IOException {
            results.add(file);
            if (this.cancelFileName.equals(file.getName())) {
                throw new DirectoryWalker.CancelException(file, depth);
            }
        }

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }
    }

    private static class TestFalseFileFinder
    extends TestFileFinder {
        protected TestFalseFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) {
            return false;
        }
    }

    private static class TestFileFinder
    extends DirectoryWalker {
        protected TestFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected TestFileFinder(IOFileFilter dirFilter, IOFileFilter fileFilter, int depthLimit) {
            super(dirFilter, fileFilter, depthLimit);
        }

        protected List find(File startDirectory) {
            ArrayList results = new ArrayList();
            try {
                this.walk(startDirectory, results);
            }
            catch (IOException ex) {
                Assert.fail((String)ex.toString());
            }
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) {
            results.add(directory);
        }

        protected void handleFile(File file, int depth, Collection results) {
            results.add(file);
        }
    }
}

