/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FilenameUtilsTestCase
extends FileBasedTestCase {
    private static final String SEP = "" + File.separatorChar;
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private File testFile1 = new File(FilenameUtilsTestCase.getTestDirectory(), "file1-test.txt");
    private File testFile2 = new File(FilenameUtilsTestCase.getTestDirectory(), "file1a-test.txt");
    private int testFile1Size = (int)this.testFile1.length();
    private int testFile2Size = (int)this.testFile2.length();

    public FilenameUtilsTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        FilenameUtilsTestCase.getTestDirectory().mkdirs();
        this.createFile(this.testFile1, this.testFile1Size);
        this.createFile(this.testFile2, this.testFile2Size);
        FileUtils.deleteDirectory((File)FilenameUtilsTestCase.getTestDirectory());
        FilenameUtilsTestCase.getTestDirectory().mkdirs();
        this.createFile(this.testFile1, this.testFile1Size);
        this.createFile(this.testFile2, this.testFile2Size);
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)FilenameUtilsTestCase.getTestDirectory());
    }

    public void testNormalize() throws Exception {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize(null));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"1:\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"\\\\\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"\\\\a"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalize((String)"a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalize((String)"\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalize((String)"C:\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalize((String)"\\\\server\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalize((String)"~\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalize((String)"~user\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "c"), (String)FilenameUtils.normalize((String)"a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.normalize((String)"a/b/../../c"));
        FilenameUtilsTestCase.assertEquals((String)("c" + SEP), (String)FilenameUtils.normalize((String)"a/b/../../c/"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP), (String)FilenameUtils.normalize((String)"a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP), (String)FilenameUtils.normalize((String)"a/b/../"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalize((String)"a/b/../.."));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalize((String)"a/b/../../"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "d"), (String)FilenameUtils.normalize((String)"a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "d" + SEP), (String)FilenameUtils.normalize((String)"a/b/../c/../d/"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"a/b/./././"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP), (String)FilenameUtils.normalize((String)"./a/"));
        FilenameUtilsTestCase.assertEquals((String)"a", (String)FilenameUtils.normalize((String)"./a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalize((String)"./"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalize((String)"."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)".."));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalize((String)""));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.normalize((String)"/a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"/a/"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "c"), (String)FilenameUtils.normalize((String)"/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "c"), (String)FilenameUtils.normalize((String)"/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalize((String)"/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "d"), (String)FilenameUtils.normalize((String)"/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.normalize((String)"/./a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalize((String)"/./"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalize((String)"/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalize((String)"/"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a"), (String)FilenameUtils.normalize((String)"~/a"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"~/a/"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalize((String)"~/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "c"), (String)FilenameUtils.normalize((String)"~/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"~/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + ""), (String)FilenameUtils.normalize((String)"~/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalize((String)"~/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"~/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"~/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a"), (String)FilenameUtils.normalize((String)"~/./a"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalize((String)"~/./"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalize((String)"~/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~/.."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalize((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalize((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a"), (String)FilenameUtils.normalize((String)"~user/a"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"~user/a/"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalize((String)"~user/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "c"), (String)FilenameUtils.normalize((String)"~user/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~user/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"~user/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + ""), (String)FilenameUtils.normalize((String)"~user/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~user/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalize((String)"~user/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"~user/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"~user/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a"), (String)FilenameUtils.normalize((String)"~user/./a"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + ""), (String)FilenameUtils.normalize((String)"~user/./"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + ""), (String)FilenameUtils.normalize((String)"~user/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~user/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"~user/.."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP), (String)FilenameUtils.normalize((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP), (String)FilenameUtils.normalize((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a"), (String)FilenameUtils.normalize((String)"C:/a"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"C:/a/"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalize((String)"C:/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "c"), (String)FilenameUtils.normalize((String)"C:/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"C:/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalize((String)"C:/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalize((String)"C:/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"C:/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"C:/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a"), (String)FilenameUtils.normalize((String)"C:/./a"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalize((String)"C:/./"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalize((String)"C:/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:/.."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalize((String)"C:/"));
        FilenameUtilsTestCase.assertEquals((String)"C:a", (String)FilenameUtils.normalize((String)"C:a"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP), (String)FilenameUtils.normalize((String)"C:a/"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "c"), (String)FilenameUtils.normalize((String)"C:a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)"C:c", (String)FilenameUtils.normalize((String)"C:a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP), (String)FilenameUtils.normalize((String)"C:a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalize((String)"C:a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "d"), (String)FilenameUtils.normalize((String)"C:a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"C:a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"C:a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)"C:a", (String)FilenameUtils.normalize((String)"C:./a"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalize((String)"C:./"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalize((String)"C:."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"C:.."));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalize((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a"), (String)FilenameUtils.normalize((String)"//server/a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"//server/a/"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalize((String)"//server/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "c"), (String)FilenameUtils.normalize((String)"//server/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"//server/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP), (String)FilenameUtils.normalize((String)"//server/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalize((String)"//server/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"//server/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalize((String)"//server/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalize((String)"//server/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP), (String)FilenameUtils.normalize((String)"//server/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a"), (String)FilenameUtils.normalize((String)"//server/./a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalize((String)"//server/./"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalize((String)"//server/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"//server/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalize((String)"//server/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalize((String)"//server/"));
    }

    public void testNormalizeUnixWin() throws Exception {
        FilenameUtilsTestCase.assertEquals((String)"/a/c/", (String)FilenameUtils.normalize((String)"/a/b/../c/", (boolean)true));
        FilenameUtilsTestCase.assertEquals((String)"/a/c/", (String)FilenameUtils.normalize((String)"\\a\\b\\..\\c\\", (boolean)true));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\c\\", (String)FilenameUtils.normalize((String)"/a/b/../c/", (boolean)false));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\c\\", (String)FilenameUtils.normalize((String)"\\a\\b\\..\\c\\", (boolean)false));
    }

    public void testNormalizeNoEndSeparator() throws Exception {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator(null));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"1:\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"\\\\\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"\\\\a"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalizeNoEndSeparator((String)"\\\\server\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user\\a\\b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../c"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../c/"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)"a", (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)"a", (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../.."));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c/../d/"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"a/b/./././"));
        FilenameUtilsTestCase.assertEquals((String)"a", (String)FilenameUtils.normalizeNoEndSeparator((String)"./a/"));
        FilenameUtilsTestCase.assertEquals((String)"a", (String)FilenameUtils.normalizeNoEndSeparator((String)"./a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalizeNoEndSeparator((String)"./"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalizeNoEndSeparator((String)"."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)".."));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.normalizeNoEndSeparator((String)""));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"/./a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"/./"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"/"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/./a"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/./"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~/.."));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalizeNoEndSeparator((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.normalizeNoEndSeparator((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/./a"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/./"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/.."));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP), (String)FilenameUtils.normalizeNoEndSeparator((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/./a"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/./"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/.."));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:/"));
        FilenameUtilsTestCase.assertEquals((String)"C:a", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a"));
        FilenameUtilsTestCase.assertEquals((String)"C:a", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)"C:c", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)"C:a", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)("C:a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)"C:a", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:./a"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:./"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"C:.."));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.normalizeNoEndSeparator((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "c"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../../c"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../.."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../c/../d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b//d"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a" + SEP + "b"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/././."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + "a"), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/./a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/./"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/."));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/../a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/.."));
        FilenameUtilsTestCase.assertEquals((String)(SEP + SEP + "server" + SEP + ""), (String)FilenameUtils.normalizeNoEndSeparator((String)"//server/"));
    }

    public void testNormalizeNoEndSeparatorUnixWin() throws Exception {
        FilenameUtilsTestCase.assertEquals((String)"/a/c", (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/", (boolean)true));
        FilenameUtilsTestCase.assertEquals((String)"/a/c", (String)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b\\..\\c\\", (boolean)true));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\c", (String)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/", (boolean)false));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\c", (String)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b\\..\\c\\", (boolean)false));
    }

    public void testConcat() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.concat((String)"", null));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.concat(null, null));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.concat(null, (String)""));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.concat(null, (String)"a"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "a"), (String)FilenameUtils.concat(null, (String)"/a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.concat((String)"", (String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.concat((String)":", (String)""));
        FilenameUtilsTestCase.assertEquals((String)("f" + SEP), (String)FilenameUtils.concat((String)"", (String)"f/"));
        FilenameUtilsTestCase.assertEquals((String)"f", (String)FilenameUtils.concat((String)"", (String)"f"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "f" + SEP), (String)FilenameUtils.concat((String)"a/", (String)"f/"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "f"), (String)FilenameUtils.concat((String)"a", (String)"f"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP + "f" + SEP), (String)FilenameUtils.concat((String)"a/b/", (String)"f/"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "b" + SEP + "f"), (String)FilenameUtils.concat((String)"a/b", (String)"f"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "f" + SEP), (String)FilenameUtils.concat((String)"a/b/", (String)"../f/"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "f"), (String)FilenameUtils.concat((String)"a/b", (String)"../f"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "c" + SEP + "g" + SEP), (String)FilenameUtils.concat((String)"a/b/../c/", (String)"f/../g/"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "c" + SEP + "g"), (String)FilenameUtils.concat((String)"a/b/../c", (String)"f/../g"));
        FilenameUtilsTestCase.assertEquals((String)("a" + SEP + "c.txt" + SEP + "f"), (String)FilenameUtils.concat((String)"a/c.txt", (String)"f"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "f" + SEP), (String)FilenameUtils.concat((String)"", (String)"/f/"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "f"), (String)FilenameUtils.concat((String)"", (String)"/f"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "f" + SEP), (String)FilenameUtils.concat((String)"a/", (String)"/f/"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "f"), (String)FilenameUtils.concat((String)"a", (String)"/f"));
        FilenameUtilsTestCase.assertEquals((String)(SEP + "c" + SEP + "d"), (String)FilenameUtils.concat((String)"a/b/", (String)"/c/d"));
        FilenameUtilsTestCase.assertEquals((String)("C:c" + SEP + "d"), (String)FilenameUtils.concat((String)"a/b/", (String)"C:c/d"));
        FilenameUtilsTestCase.assertEquals((String)("C:" + SEP + "c" + SEP + "d"), (String)FilenameUtils.concat((String)"a/b/", (String)"C:/c/d"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP + "c" + SEP + "d"), (String)FilenameUtils.concat((String)"a/b/", (String)"~/c/d"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP + "c" + SEP + "d"), (String)FilenameUtils.concat((String)"a/b/", (String)"~user/c/d"));
        FilenameUtilsTestCase.assertEquals((String)("~" + SEP), (String)FilenameUtils.concat((String)"a/b/", (String)"~"));
        FilenameUtilsTestCase.assertEquals((String)("~user" + SEP), (String)FilenameUtils.concat((String)"a/b/", (String)"~user"));
    }

    public void testSeparatorsToUnix() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.separatorsToUnix(null));
        FilenameUtilsTestCase.assertEquals((String)"/a/b/c", (String)FilenameUtils.separatorsToUnix((String)"/a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"/a/b/c.txt", (String)FilenameUtils.separatorsToUnix((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"/a/b/c", (String)FilenameUtils.separatorsToUnix((String)"/a/b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"/a/b/c", (String)FilenameUtils.separatorsToUnix((String)"\\a\\b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"D:/a/b/c", (String)FilenameUtils.separatorsToUnix((String)"D:\\a\\b\\c"));
    }

    public void testSeparatorsToWindows() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.separatorsToWindows(null));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c", (String)FilenameUtils.separatorsToWindows((String)"\\a\\b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c.txt", (String)FilenameUtils.separatorsToWindows((String)"\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c", (String)FilenameUtils.separatorsToWindows((String)"\\a\\b/c"));
        FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c", (String)FilenameUtils.separatorsToWindows((String)"/a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"D:\\a\\b\\c", (String)FilenameUtils.separatorsToWindows((String)"D:/a/b/c"));
    }

    public void testSeparatorsToSystem() {
        if (WINDOWS) {
            FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.separatorsToSystem(null));
            FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c", (String)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c"));
            FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c.txt", (String)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c.txt"));
            FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c", (String)FilenameUtils.separatorsToSystem((String)"\\a\\b/c"));
            FilenameUtilsTestCase.assertEquals((String)"\\a\\b\\c", (String)FilenameUtils.separatorsToSystem((String)"/a/b/c"));
            FilenameUtilsTestCase.assertEquals((String)"D:\\a\\b\\c", (String)FilenameUtils.separatorsToSystem((String)"D:/a/b/c"));
        } else {
            FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.separatorsToSystem(null));
            FilenameUtilsTestCase.assertEquals((String)"/a/b/c", (String)FilenameUtils.separatorsToSystem((String)"/a/b/c"));
            FilenameUtilsTestCase.assertEquals((String)"/a/b/c.txt", (String)FilenameUtils.separatorsToSystem((String)"/a/b/c.txt"));
            FilenameUtilsTestCase.assertEquals((String)"/a/b/c", (String)FilenameUtils.separatorsToSystem((String)"/a/b\\c"));
            FilenameUtilsTestCase.assertEquals((String)"/a/b/c", (String)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c"));
            FilenameUtilsTestCase.assertEquals((String)"D:/a/b/c", (String)FilenameUtils.separatorsToSystem((String)"D:\\a\\b\\c"));
        }
    }

    public void testGetPrefixLength() {
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength(null));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)":"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"1:\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"1:"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"1:a"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\a"));
        FilenameUtilsTestCase.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)""));
        FilenameUtilsTestCase.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"\\"));
        FilenameUtilsTestCase.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"C:"));
        FilenameUtilsTestCase.assertEquals((int)3, (int)FilenameUtils.getPrefixLength((String)"C:\\"));
        FilenameUtilsTestCase.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"//server/"));
        FilenameUtilsTestCase.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~"));
        FilenameUtilsTestCase.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~/"));
        FilenameUtilsTestCase.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user"));
        FilenameUtilsTestCase.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)"a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"C:a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)3, (int)FilenameUtils.getPrefixLength((String)"C:\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"\\\\server\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)3, (int)FilenameUtils.getPrefixLength((String)"C:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"//server/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)"a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user\\a\\b\\c.txt"));
    }

    public void testIndexOfLastSeparator() {
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfLastSeparator(null));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfLastSeparator((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((int)3, (int)FilenameUtils.indexOfLastSeparator((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((int)3, (int)FilenameUtils.indexOfLastSeparator((String)"a\\b\\c"));
    }

    public void testIndexOfExtension() {
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension(null));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"file"));
        FilenameUtilsTestCase.assertEquals((int)4, (int)FilenameUtils.indexOfExtension((String)"file.txt"));
        FilenameUtilsTestCase.assertEquals((int)13, (int)FilenameUtils.indexOfExtension((String)"a.txt/b.txt/c.txt"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a/b.notextension/c"));
        FilenameUtilsTestCase.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a\\b.notextension\\c"));
    }

    public void testGetPrefix() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix(null));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix((String)"1:\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix((String)"\\\\\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPrefix((String)"\\\\a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPrefix((String)""));
        FilenameUtilsTestCase.assertEquals((String)"\\", (String)FilenameUtils.getPrefix((String)"\\"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.getPrefix((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)"C:\\", (String)FilenameUtils.getPrefix((String)"C:\\"));
        FilenameUtilsTestCase.assertEquals((String)"//server/", (String)FilenameUtils.getPrefix((String)"//server/"));
        FilenameUtilsTestCase.assertEquals((String)"~/", (String)FilenameUtils.getPrefix((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)"~/", (String)FilenameUtils.getPrefix((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)"~user/", (String)FilenameUtils.getPrefix((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)"~user/", (String)FilenameUtils.getPrefix((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPrefix((String)"a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"\\", (String)FilenameUtils.getPrefix((String)"\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"C:\\", (String)FilenameUtils.getPrefix((String)"C:\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"\\\\server\\", (String)FilenameUtils.getPrefix((String)"\\\\server\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPrefix((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"/", (String)FilenameUtils.getPrefix((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"C:/", (String)FilenameUtils.getPrefix((String)"C:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"//server/", (String)FilenameUtils.getPrefix((String)"//server/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~/", (String)FilenameUtils.getPrefix((String)"~/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~user/", (String)FilenameUtils.getPrefix((String)"~user/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPrefix((String)"a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"\\", (String)FilenameUtils.getPrefix((String)"\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~\\", (String)FilenameUtils.getPrefix((String)"~\\a\\b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~user\\", (String)FilenameUtils.getPrefix((String)"~user\\a\\b\\c.txt"));
    }

    public void testGetPath() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath(null));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"/noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"\\noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/c/", (String)FilenameUtils.getPath((String)"a/b/c/"));
        FilenameUtilsTestCase.assertEquals((String)"a\\b\\", (String)FilenameUtils.getPath((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath((String)"1:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath((String)"///a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath((String)"//a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)""));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"C:/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"//server/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"C:a"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"C:a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"C:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"//server/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"~/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getPath((String)"~user/a/b/c.txt"));
    }

    public void testGetPathNoEndSeparator() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPath(null));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPath((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"/noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"\\noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/c", (String)FilenameUtils.getPathNoEndSeparator((String)"a/b/c/"));
        FilenameUtilsTestCase.assertEquals((String)"a\\b", (String)FilenameUtils.getPathNoEndSeparator((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPathNoEndSeparator((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPathNoEndSeparator((String)"1:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPathNoEndSeparator((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPathNoEndSeparator((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPathNoEndSeparator((String)"///a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getPathNoEndSeparator((String)"//a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)""));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"C:/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"//server/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getPathNoEndSeparator((String)"C:a"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"C:a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"C:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"//server/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"~/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getPathNoEndSeparator((String)"~user/a/b/c.txt"));
    }

    public void testGetFullPath() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath(null));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getFullPath((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getFullPath((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getFullPath((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/c/", (String)FilenameUtils.getFullPath((String)"a/b/c/"));
        FilenameUtilsTestCase.assertEquals((String)"a\\b\\", (String)FilenameUtils.getFullPath((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath((String)"1:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath((String)"///a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPath((String)"//a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getFullPath((String)""));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.getFullPath((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)"C:/", (String)FilenameUtils.getFullPath((String)"C:/"));
        FilenameUtilsTestCase.assertEquals((String)"//server/", (String)FilenameUtils.getFullPath((String)"//server/"));
        FilenameUtilsTestCase.assertEquals((String)"~/", (String)FilenameUtils.getFullPath((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)"~/", (String)FilenameUtils.getFullPath((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)"~user/", (String)FilenameUtils.getFullPath((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)"~user/", (String)FilenameUtils.getFullPath((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/", (String)FilenameUtils.getFullPath((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"/a/b/", (String)FilenameUtils.getFullPath((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.getFullPath((String)"C:a"));
        FilenameUtilsTestCase.assertEquals((String)"C:a/b/", (String)FilenameUtils.getFullPath((String)"C:a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"C:/a/b/", (String)FilenameUtils.getFullPath((String)"C:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"//server/a/b/", (String)FilenameUtils.getFullPath((String)"//server/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~/a/b/", (String)FilenameUtils.getFullPath((String)"~/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~user/a/b/", (String)FilenameUtils.getFullPath((String)"~user/a/b/c.txt"));
    }

    public void testGetFullPathNoEndSeparator() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator(null));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getFullPathNoEndSeparator((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/c", (String)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c/"));
        FilenameUtilsTestCase.assertEquals((String)"a\\b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator((String)":"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator((String)"1:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator((String)"1:"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator((String)"1:a"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator((String)"///a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getFullPathNoEndSeparator((String)"//a"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getFullPathNoEndSeparator((String)""));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.getFullPathNoEndSeparator((String)"C:"));
        FilenameUtilsTestCase.assertEquals((String)"C:/", (String)FilenameUtils.getFullPathNoEndSeparator((String)"C:/"));
        FilenameUtilsTestCase.assertEquals((String)"//server/", (String)FilenameUtils.getFullPathNoEndSeparator((String)"//server/"));
        FilenameUtilsTestCase.assertEquals((String)"~", (String)FilenameUtils.getFullPathNoEndSeparator((String)"~"));
        FilenameUtilsTestCase.assertEquals((String)"~/", (String)FilenameUtils.getFullPathNoEndSeparator((String)"~/"));
        FilenameUtilsTestCase.assertEquals((String)"~user", (String)FilenameUtils.getFullPathNoEndSeparator((String)"~user"));
        FilenameUtilsTestCase.assertEquals((String)"~user/", (String)FilenameUtils.getFullPathNoEndSeparator((String)"~user/"));
        FilenameUtilsTestCase.assertEquals((String)"a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"/a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"C:", (String)FilenameUtils.getFullPathNoEndSeparator((String)"C:a"));
        FilenameUtilsTestCase.assertEquals((String)"C:a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"C:a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"C:/a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"C:/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"//server/a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"//server/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~/a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"~/a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"~user/a/b", (String)FilenameUtils.getFullPathNoEndSeparator((String)"~user/a/b/c.txt"));
    }

    public void testGetFullPathNoEndSeparator_IO_248() {
        FilenameUtilsTestCase.assertEquals((String)"/", (String)FilenameUtils.getFullPathNoEndSeparator((String)"/"));
        FilenameUtilsTestCase.assertEquals((String)"\\", (String)FilenameUtils.getFullPathNoEndSeparator((String)"\\"));
        FilenameUtilsTestCase.assertEquals((String)"/", (String)FilenameUtils.getFullPathNoEndSeparator((String)"/abc"));
        FilenameUtilsTestCase.assertEquals((String)"\\", (String)FilenameUtils.getFullPathNoEndSeparator((String)"\\abc"));
        FilenameUtilsTestCase.assertEquals((String)"/abc", (String)FilenameUtils.getFullPathNoEndSeparator((String)"/abc/xyz"));
        FilenameUtilsTestCase.assertEquals((String)"\\abc", (String)FilenameUtils.getFullPathNoEndSeparator((String)"\\abc\\xyz"));
    }

    public void testGetName() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getName(null));
        FilenameUtilsTestCase.assertEquals((String)"noseperator.inthispath", (String)FilenameUtils.getName((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"c.txt", (String)FilenameUtils.getName((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.getName((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getName((String)"a/b/c/"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.getName((String)"a\\b\\c"));
    }

    public void testGetBaseName() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getBaseName(null));
        FilenameUtilsTestCase.assertEquals((String)"noseperator", (String)FilenameUtils.getBaseName((String)"noseperator.inthispath"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.getBaseName((String)"a/b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.getBaseName((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getBaseName((String)"a/b/c/"));
        FilenameUtilsTestCase.assertEquals((String)"c", (String)FilenameUtils.getBaseName((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"file.txt", (String)FilenameUtils.getBaseName((String)"file.txt.bak"));
    }

    public void testGetExtension() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.getExtension(null));
        FilenameUtilsTestCase.assertEquals((String)"ext", (String)FilenameUtils.getExtension((String)"file.ext"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getExtension((String)"README"));
        FilenameUtilsTestCase.assertEquals((String)"com", (String)FilenameUtils.getExtension((String)"domain.dot.com"));
        FilenameUtilsTestCase.assertEquals((String)"jpeg", (String)FilenameUtils.getExtension((String)"image.jpeg"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getExtension((String)"a.b/c"));
        FilenameUtilsTestCase.assertEquals((String)"txt", (String)FilenameUtils.getExtension((String)"a.b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getExtension((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getExtension((String)"a.b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"txt", (String)FilenameUtils.getExtension((String)"a.b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getExtension((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"", (String)FilenameUtils.getExtension((String)"C:\\temp\\foo.bar\\README"));
        FilenameUtilsTestCase.assertEquals((String)"ext", (String)FilenameUtils.getExtension((String)"../filename.ext"));
    }

    public void testRemoveExtension() {
        FilenameUtilsTestCase.assertEquals(null, (String)FilenameUtils.removeExtension(null));
        FilenameUtilsTestCase.assertEquals((String)"file", (String)FilenameUtils.removeExtension((String)"file.ext"));
        FilenameUtilsTestCase.assertEquals((String)"README", (String)FilenameUtils.removeExtension((String)"README"));
        FilenameUtilsTestCase.assertEquals((String)"domain.dot", (String)FilenameUtils.removeExtension((String)"domain.dot.com"));
        FilenameUtilsTestCase.assertEquals((String)"image", (String)FilenameUtils.removeExtension((String)"image.jpeg"));
        FilenameUtilsTestCase.assertEquals((String)"a.b/c", (String)FilenameUtils.removeExtension((String)"a.b/c"));
        FilenameUtilsTestCase.assertEquals((String)"a.b/c", (String)FilenameUtils.removeExtension((String)"a.b/c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a/b/c", (String)FilenameUtils.removeExtension((String)"a/b/c"));
        FilenameUtilsTestCase.assertEquals((String)"a.b\\c", (String)FilenameUtils.removeExtension((String)"a.b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"a.b\\c", (String)FilenameUtils.removeExtension((String)"a.b\\c.txt"));
        FilenameUtilsTestCase.assertEquals((String)"a\\b\\c", (String)FilenameUtils.removeExtension((String)"a\\b\\c"));
        FilenameUtilsTestCase.assertEquals((String)"C:\\temp\\foo.bar\\README", (String)FilenameUtils.removeExtension((String)"C:\\temp\\foo.bar\\README"));
        FilenameUtilsTestCase.assertEquals((String)"../filename", (String)FilenameUtils.removeExtension((String)"../filename.ext"));
    }

    public void testEquals() {
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equals(null, null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equals(null, (String)""));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equals((String)"", null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equals((String)"", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equals((String)"file.txt", (String)"file.txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equals((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
    }

    public void testEqualsOnSystem() {
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsOnSystem(null, null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsOnSystem(null, (String)""));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsOnSystem((String)"", null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsOnSystem((String)"", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsOnSystem((String)"file.txt", (String)"file.txt"));
        FilenameUtilsTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.equalsOnSystem((String)"file.txt", (String)"FILE.TXT"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsOnSystem((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
    }

    public void testEqualsNormalized() {
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalized(null, null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalized(null, (String)""));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"", null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"file.txt", (String)"file.txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"file.txt", (String)"FILE.TXT"));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"a/b/", (String)"a/b"));
    }

    public void testEqualsNormalizedOnSystem() {
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem(null, null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem(null, (String)""));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"", null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"file.txt"));
        FilenameUtilsTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"FILE.TXT"));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"a/b/", (String)"a/b"));
    }

    public void testEqualsNormalizedError_IO_128() {
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"//file.txt", (String)"file.txt");
            FilenameUtilsTestCase.fail((String)"Invalid normalized first file");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"//file.txt");
            FilenameUtilsTestCase.fail((String)"Invalid normalized second file");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"//file.txt", (String)"//file.txt");
            FilenameUtilsTestCase.fail((String)"Invalid normalized both filse");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquals_fullControl() {
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.SENSITIVE));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.INSENSITIVE));
        FilenameUtilsTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.SYSTEM));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, null));
    }

    public void testIsExtension() {
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension(null, (String)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"rtf"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"rtf"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"rtf"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"rtf"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)""));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"txt"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"rtf"));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"TXT"));
    }

    public void testIsExtensionArray() {
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension(null, (String[])null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[0]));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf"}));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])new String[]{"rtf", ""}));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf", "txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[0]));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf"}));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf", "txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[0]));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf"}));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf", "txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[0]));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf"}));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[0]));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf"}));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT"}));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT", "RTF"}));
    }

    public void testIsExtensionCollection() {
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension(null, (Collection)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (Collection)null));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (Collection)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList()));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file", new ArrayList<String>(Arrays.asList("rtf", ""))));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (Collection)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList()));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (Collection)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList()));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (Collection)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList()));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (Collection)null));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList()));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        FilenameUtilsTestCase.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT"))));
        FilenameUtilsTestCase.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT", "RTF"))));
    }
}

