/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class FilenameUtilsWildcardTestCase
extends TestCase {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public FilenameUtilsWildcardTestCase(String name) {
        super(name);
    }

    public void testMatch() {
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch(null, (String)"Foo"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", null));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)""));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)"*"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"", (String)"?"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo?"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar and Catflap", (String)"Fo*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Bar"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar Foo", (String)"F*o Bar*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BarFoo", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FooBar", (String)"Foo*"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*"));
    }

    public void testMatchOnSystem() {
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem(null, (String)"Foo"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", null));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem(null, null));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Foo"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"", (String)""));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Fo*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Fo?"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo Bar and Catflap", (String)"Fo*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Bar"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo Bar Foo", (String)"F*o Bar*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"BarFoo", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Foo*"));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"FooBar", (String)"Foo*"));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatchOnSystem((String)"FOO", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatchOnSystem((String)"BARFOO", (String)"*Foo"));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatchOnSystem((String)"FOO", (String)"Foo*"));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatchOnSystem((String)"FOOBAR", (String)"Foo*"));
    }

    public void testMatchCaseSpecified() {
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch(null, (String)"Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", null, (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null, (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)"", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo?", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar and Catflap", (String)"Fo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"New Bookmarks", (String)"N?w ?o?k??r?s", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Bar", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar Foo", (String)"F*o Bar*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Adobe Acrobat Installer", (String)"Ad*er", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BarFoo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FooBar", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.INSENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.INSENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.INSENSITIVE));
        FilenameUtilsWildcardTestCase.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.INSENSITIVE));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.SYSTEM));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.SYSTEM));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.SYSTEM));
        FilenameUtilsWildcardTestCase.assertEquals((boolean)WINDOWS, (boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.SYSTEM));
    }

    public void testSplitOnTokens() {
        this.assertArrayEquals(new String[]{"Ad", "*", "er"}, FilenameUtils.splitOnTokens((String)"Ad*er"));
        this.assertArrayEquals(new String[]{"Ad", "?", "er"}, FilenameUtils.splitOnTokens((String)"Ad?er"));
        this.assertArrayEquals(new String[]{"Test", "*", "?", "One"}, FilenameUtils.splitOnTokens((String)"Test*?One"));
        this.assertArrayEquals(new String[]{"Test", "?", "*", "One"}, FilenameUtils.splitOnTokens((String)"Test?*One"));
        this.assertArrayEquals(new String[]{"*"}, FilenameUtils.splitOnTokens((String)"****"));
        this.assertArrayEquals(new String[]{"*", "?", "?", "*"}, FilenameUtils.splitOnTokens((String)"*??*"));
        this.assertArrayEquals(new String[]{"*", "?", "*", "?", "*"}, FilenameUtils.splitOnTokens((String)"*?**?*"));
        this.assertArrayEquals(new String[]{"h", "?", "?", "*"}, FilenameUtils.splitOnTokens((String)"h??*"));
        this.assertArrayEquals(new String[]{""}, FilenameUtils.splitOnTokens((String)""));
    }

    private void assertArrayEquals(Object[] a1, Object[] a2) {
        FilenameUtilsWildcardTestCase.assertEquals((int)a1.length, (int)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            FilenameUtilsWildcardTestCase.assertEquals((Object)a1[i], (Object)a2[i]);
        }
    }

    private void assertMatch(String text, String wildcard, boolean expected) {
        FilenameUtilsWildcardTestCase.assertEquals((String)(text + " " + wildcard), (boolean)expected, (boolean)FilenameUtils.wildcardMatch((String)text, (String)wildcard));
    }

    public void testMatch2() {
        this.assertMatch("log.txt", "log.txt", true);
        this.assertMatch("log.txt1", "log.txt", false);
        this.assertMatch("log.txt", "log.txt*", true);
        this.assertMatch("log.txt", "log.txt*1", false);
        this.assertMatch("log.txt", "*log.txt*", true);
        this.assertMatch("log.txt", "*.txt", true);
        this.assertMatch("txt.log", "*.txt", false);
        this.assertMatch("config.ini", "*.ini", true);
        this.assertMatch("config.txt.bak", "con*.txt", false);
        this.assertMatch("log.txt9", "*.txt?", true);
        this.assertMatch("log.txt", "*.txt?", false);
        this.assertMatch("progtestcase.java~5~", "*test*.java~*~", true);
        this.assertMatch("progtestcase.java;5~", "*test*.java~*~", false);
        this.assertMatch("progtestcase.java~5", "*test*.java~*~", false);
        this.assertMatch("log.txt", "log.*", true);
        this.assertMatch("log.txt", "log?*", true);
        this.assertMatch("log.txt12", "log.txt??", true);
        this.assertMatch("log.log", "log**log", true);
        this.assertMatch("log.log", "log**", true);
        this.assertMatch("log.log", "log.**", true);
        this.assertMatch("log.log", "**.log", true);
        this.assertMatch("log.log", "**log", true);
        this.assertMatch("log.log", "log*log", true);
        this.assertMatch("log.log", "log*", true);
        this.assertMatch("log.log", "log.*", true);
        this.assertMatch("log.log", "*.log", true);
        this.assertMatch("log.log", "*log", true);
        this.assertMatch("log.log", "*log?", false);
        this.assertMatch("log.log", "*log?*", true);
        this.assertMatch("log.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc.d", "*log?abc?d", true);
    }

    public void test_IO_246() {
        this.assertMatch("aaa", "aa*?", true);
        this.assertMatch("", "?*", false);
        this.assertMatch("a", "a?*", false);
        this.assertMatch("aa", "aa?*", false);
        this.assertMatch("a", "?*", true);
        this.assertMatch("aa", "?*", true);
        this.assertMatch("aaa", "?*", true);
        this.assertMatch("", "?", false);
        this.assertMatch("a", "a?", false);
        this.assertMatch("aa", "aa?", false);
        this.assertMatch("aab", "aa?", true);
        this.assertMatch("aaa", "*a", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = Locale.getAvailableLocales();
        String[][] data = new String[][]{{"I", "i"}, {"i", "I"}, {"i", "\u0130"}, {"i", "\u0131"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}, {"\u03c2", "\u03c3"}};
        try {
            for (int i = 0; i < data.length; ++i) {
                for (Locale locale : locales) {
                    Locale.setDefault(locale);
                    FilenameUtilsWildcardTestCase.assertTrue((String)("Test data corrupt: " + i), (boolean)data[i][0].equalsIgnoreCase(data[i][1]));
                    boolean match = FilenameUtils.wildcardMatch((String)data[i][0], (String)data[i][1], (IOCase)IOCase.INSENSITIVE);
                    FilenameUtilsWildcardTestCase.assertTrue((String)(Locale.getDefault().toString() + ": " + i), (boolean)match);
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }
}

