/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.testtools.FileBasedTestCase;
import org.apache.commons.io.testtools.YellOnCloseInputStream;
import org.apache.commons.io.testtools.YellOnFlushAndCloseOutputStream;

public class IOUtilsCopyTestCase
extends FileBasedTestCase {
    private static final int FILE_SIZE = 4097;
    private byte[] inData = this.generateTestData(4097L);

    public IOUtilsCopyTestCase(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCopy_inputStreamToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        int count = IOUtils.copy((InputStream)in, (OutputStream)((Object)out));
        IOUtilsCopyTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)((InputStream)in).available());
        IOUtilsCopyTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
        IOUtilsCopyTestCase.assertEquals((int)this.inData.length, (int)count);
    }

    public void testCopy_inputStreamToOutputStream_nullIn() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)null, (OutputStream)out);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_inputStreamToOutputStream_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)null);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_inputStreamToOutputStream_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream in = new NullInputStream(size);
        NullOutputStream out = new NullOutputStream();
        IOUtilsCopyTestCase.assertEquals((int)-1, (int)IOUtils.copy((InputStream)in, (OutputStream)out));
        in.close();
        IOUtilsCopyTestCase.assertEquals((String)"copyLarge()", (long)size, (long)IOUtils.copyLarge((InputStream)in, (OutputStream)out));
    }

    public void testCopy_inputStreamToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsCopyTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)((InputStream)in).available());
        IOUtilsCopyTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_inputStreamToWriter_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        try {
            IOUtils.copy((InputStream)null, (Writer)writer);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public void testCopy_inputStreamToWriter_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        try {
            IOUtils.copy((InputStream)in, (Writer)null);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_inputStreamToWriter_Encoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        IOUtilsCopyTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)((InputStream)in).available());
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF8").getBytes("US-ASCII");
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    public void testCopy_inputStreamToWriter_Encoding_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        try {
            IOUtils.copy((InputStream)null, (Writer)writer, (String)"UTF8");
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public void testCopy_inputStreamToWriter_Encoding_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        try {
            IOUtils.copy((InputStream)in, (Writer)null, (String)"UTF8");
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_inputStreamToWriter_Encoding_nullEncoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        IOUtilsCopyTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)((InputStream)in).available());
        IOUtilsCopyTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_readerToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out));
        IOUtilsCopyTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_readerToOutputStream_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        try {
            IOUtils.copy((Reader)null, (OutputStream)((Object)out));
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_readerToOutputStream_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        try {
            IOUtils.copy((Reader)reader, (OutputStream)null);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_readerToOutputStream_Encoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)"UTF16");
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF16").getBytes("US-ASCII");
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    public void testCopy_readerToOutputStream_Encoding_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        try {
            IOUtils.copy((Reader)null, (OutputStream)((Object)out), (String)"UTF16");
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_readerToOutputStream_Encoding_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        try {
            IOUtils.copy((Reader)reader, (OutputStream)null, (String)"UTF16");
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_readerToOutputStream_Encoding_nullEncoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)null);
        IOUtilsCopyTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_readerToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        int count = IOUtils.copy((Reader)reader, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsCopyTestCase.assertEquals((String)"The number of characters returned by copy is wrong", (int)this.inData.length, (int)count);
        IOUtilsCopyTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsCopyTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_readerToWriter_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        try {
            IOUtils.copy((Reader)null, (Writer)writer);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public void testCopy_readerToWriter_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        try {
            IOUtils.copy((Reader)reader, (Writer)null);
            IOUtilsCopyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopy_readerToWriter_IO84() throws Exception {
        long size = 0x80000000L;
        NullReader reader = new NullReader(size);
        NullWriter writer = new NullWriter();
        IOUtilsCopyTestCase.assertEquals((int)-1, (int)IOUtils.copy((Reader)reader, (Writer)writer));
        reader.close();
        IOUtilsCopyTestCase.assertEquals((String)"copyLarge()", (long)size, (long)IOUtils.copyLarge((Reader)reader, (Writer)writer));
    }
}

