/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.DefaultFileComparator;
import org.apache.commons.io.testtools.FileBasedTestCase;

public abstract class ComparatorAbstractTestCase
extends FileBasedTestCase {
    protected AbstractFileComparator comparator;
    protected Comparator<File> reverse;
    protected File equalFile1;
    protected File equalFile2;
    protected File lessFile;
    protected File moreFile;

    public ComparatorAbstractTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)DefaultFileComparator.DEFAULT_COMPARATOR;
        this.reverse = DefaultFileComparator.DEFAULT_REVERSE;
    }

    protected void tearDown() throws Exception {
        this.comparator = null;
        this.reverse = null;
        this.equalFile1 = null;
        this.equalFile2 = null;
        this.lessFile = null;
        this.moreFile = null;
        FileUtils.deleteDirectory((File)ComparatorAbstractTestCase.getTestDirectory());
    }

    public void testComparator() {
        ComparatorAbstractTestCase.assertEquals((String)"equal", (int)0, (int)this.comparator.compare((Object)this.equalFile1, (Object)this.equalFile2));
        ComparatorAbstractTestCase.assertTrue((String)"less", (this.comparator.compare((Object)this.lessFile, (Object)this.moreFile) < 0 ? 1 : 0) != 0);
        ComparatorAbstractTestCase.assertTrue((String)"more", (this.comparator.compare((Object)this.moreFile, (Object)this.lessFile) > 0 ? 1 : 0) != 0);
    }

    public void testReverseComparator() {
        ComparatorAbstractTestCase.assertEquals((String)"equal", (int)0, (int)this.reverse.compare(this.equalFile1, this.equalFile2));
        ComparatorAbstractTestCase.assertTrue((String)"less", (this.reverse.compare(this.moreFile, this.lessFile) < 0 ? 1 : 0) != 0);
        ComparatorAbstractTestCase.assertTrue((String)"more", (this.reverse.compare(this.lessFile, this.moreFile) > 0 ? 1 : 0) != 0);
    }

    public void testSortArrayNull() {
        ComparatorAbstractTestCase.assertNull((Object)this.comparator.sort((File[])null));
    }

    public void testSortArray() {
        File[] files = new File[]{this.equalFile1, this.moreFile, this.lessFile};
        this.comparator.sort(files);
        ComparatorAbstractTestCase.assertSame((String)"equal", (Object)this.lessFile, (Object)files[0]);
        ComparatorAbstractTestCase.assertSame((String)"less", (Object)this.equalFile1, (Object)files[1]);
        ComparatorAbstractTestCase.assertSame((String)"more", (Object)this.moreFile, (Object)files[2]);
    }

    public void testSortList() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(this.equalFile1);
        files.add(this.moreFile);
        files.add(this.lessFile);
        this.comparator.sort(files);
        ComparatorAbstractTestCase.assertSame((String)"equal", (Object)this.lessFile, files.get(0));
        ComparatorAbstractTestCase.assertSame((String)"less", (Object)this.equalFile1, files.get(1));
        ComparatorAbstractTestCase.assertSame((String)"more", (Object)this.moreFile, files.get(2));
    }

    public void testSortListNull() {
        ComparatorAbstractTestCase.assertNull((Object)this.comparator.sort((List)null));
    }

    public void testToString() {
        ComparatorAbstractTestCase.assertNotNull((String)"comparator", (Object)this.comparator.toString());
        ComparatorAbstractTestCase.assertTrue((String)"reverse", (boolean)this.reverse.toString().startsWith("ReverseComparator["));
    }
}

