/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.NullInputStream;

public class NullInputStreamTest
extends TestCase {
    public NullInputStreamTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRead() throws Exception {
        int size = 5;
        TestNullInputStream input = new TestNullInputStream(size);
        for (int i = 0; i < size; ++i) {
            NullInputStreamTest.assertEquals((String)("Check Size [" + i + "]"), (int)(size - i), (int)((InputStream)((Object)input)).available());
            NullInputStreamTest.assertEquals((String)("Check Value [" + i + "]"), (int)i, (int)((InputStream)((Object)input)).read());
        }
        NullInputStreamTest.assertEquals((String)"Available after contents all read", (int)0, (int)((InputStream)((Object)input)).available());
        NullInputStreamTest.assertEquals((String)"End of File", (int)-1, (int)((InputStream)((Object)input)).read());
        NullInputStreamTest.assertEquals((String)"Available after End of File", (int)0, (int)((InputStream)((Object)input)).available());
        try {
            int result = ((InputStream)((Object)input)).read();
            NullInputStreamTest.fail((String)("Should have thrown an IOException, byte=[" + result + "]"));
        }
        catch (IOException e) {
            NullInputStreamTest.assertEquals((String)"Read after end of file", (String)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
        NullInputStreamTest.assertEquals((String)"Available after close", (int)size, (int)((InputStream)((Object)input)).available());
    }

    public void testReadByteArray() throws Exception {
        byte[] bytes = new byte[10];
        TestNullInputStream input = new TestNullInputStream(15);
        int count1 = ((InputStream)((Object)input)).read(bytes);
        NullInputStreamTest.assertEquals((String)"Read 1", (int)bytes.length, (int)count1);
        for (int i = 0; i < count1; ++i) {
            NullInputStreamTest.assertEquals((String)"Check Bytes 1", (int)i, (int)bytes[i]);
        }
        int count2 = ((InputStream)((Object)input)).read(bytes);
        NullInputStreamTest.assertEquals((String)"Read 2", (int)5, (int)count2);
        for (int i = 0; i < count2; ++i) {
            NullInputStreamTest.assertEquals((String)"Check Bytes 2", (int)(count1 + i), (int)bytes[i]);
        }
        int count3 = ((InputStream)((Object)input)).read(bytes);
        NullInputStreamTest.assertEquals((String)"Read 3 (EOF)", (int)-1, (int)count3);
        try {
            int count4 = ((InputStream)((Object)input)).read(bytes);
            NullInputStreamTest.fail((String)("Should have thrown an IOException, byte=[" + count4 + "]"));
        }
        catch (IOException e) {
            NullInputStreamTest.assertEquals((String)"Read after end of file", (String)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
        int offset = 2;
        int lth = 4;
        int count5 = ((InputStream)((Object)input)).read(bytes, offset, lth);
        NullInputStreamTest.assertEquals((String)"Read 5", (int)lth, (int)count5);
        for (int i = offset; i < lth; ++i) {
            NullInputStreamTest.assertEquals((String)"Check Bytes 2", (int)i, (int)bytes[i]);
        }
    }

    public void testEOFException() throws Exception {
        TestNullInputStream input = new TestNullInputStream(2, false, true);
        NullInputStreamTest.assertEquals((String)"Read 1", (int)0, (int)((InputStream)((Object)input)).read());
        NullInputStreamTest.assertEquals((String)"Read 2", (int)1, (int)((InputStream)((Object)input)).read());
        try {
            int result = ((InputStream)((Object)input)).read();
            NullInputStreamTest.fail((String)("Should have thrown an EOFException, byte=[" + result + "]"));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testMarkAndReset() throws Exception {
        int i;
        int position = 0;
        int readlimit = 10;
        TestNullInputStream input = new TestNullInputStream(100, true, false);
        NullInputStreamTest.assertTrue((String)"Mark Should be Supported", (boolean)((InputStream)((Object)input)).markSupported());
        try {
            ((InputStream)((Object)input)).reset();
            NullInputStreamTest.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            NullInputStreamTest.assertEquals((String)"No Mark IOException message", (String)"No position has been marked", (String)e.getMessage());
        }
        while (position < 3) {
            NullInputStreamTest.assertEquals((String)("Read Before Mark [" + position + "]"), (int)position, (int)((InputStream)((Object)input)).read());
            ++position;
        }
        ((InputStream)((Object)input)).mark(readlimit);
        for (i = 0; i < 3; ++i) {
            NullInputStreamTest.assertEquals((String)("Read After Mark [" + i + "]"), (int)(position + i), (int)((InputStream)((Object)input)).read());
        }
        ((InputStream)((Object)input)).reset();
        for (i = 0; i < readlimit + 1; ++i) {
            NullInputStreamTest.assertEquals((String)("Read After Reset [" + i + "]"), (int)(position + i), (int)((InputStream)((Object)input)).read());
        }
        try {
            ((InputStream)((Object)input)).reset();
            NullInputStreamTest.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            NullInputStreamTest.assertEquals((String)"Read limit IOException message", (String)("Marked position [" + position + "] is no longer valid - passed the read limit [" + readlimit + "]"), (String)e.getMessage());
        }
    }

    public void testMarkNotSupported() throws Exception {
        TestNullInputStream input = new TestNullInputStream(100, false, true);
        NullInputStreamTest.assertFalse((String)"Mark Should NOT be Supported", (boolean)((InputStream)((Object)input)).markSupported());
        try {
            ((InputStream)((Object)input)).mark(5);
            NullInputStreamTest.fail((String)"mark() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            NullInputStreamTest.assertEquals((String)"mark() error message", (String)"Mark not supported", (String)e.getMessage());
        }
        try {
            ((InputStream)((Object)input)).reset();
            NullInputStreamTest.fail((String)"reset() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            NullInputStreamTest.assertEquals((String)"reset() error message", (String)"Mark not supported", (String)e.getMessage());
        }
    }

    public void testSkip() throws Exception {
        TestNullInputStream input = new TestNullInputStream(10, true, false);
        NullInputStreamTest.assertEquals((String)"Read 1", (int)0, (int)((InputStream)((Object)input)).read());
        NullInputStreamTest.assertEquals((String)"Read 2", (int)1, (int)((InputStream)((Object)input)).read());
        NullInputStreamTest.assertEquals((String)"Skip 1", (long)5L, (long)((InputStream)((Object)input)).skip(5L));
        NullInputStreamTest.assertEquals((String)"Read 3", (int)7, (int)((InputStream)((Object)input)).read());
        NullInputStreamTest.assertEquals((String)"Skip 2", (long)2L, (long)((InputStream)((Object)input)).skip(5L));
        NullInputStreamTest.assertEquals((String)"Skip 3 (EOF)", (long)-1L, (long)((InputStream)((Object)input)).skip(5L));
        try {
            ((InputStream)((Object)input)).skip(5L);
            NullInputStreamTest.fail((String)"Expected IOException for skipping after end of file");
        }
        catch (IOException e) {
            NullInputStreamTest.assertEquals((String)"Skip after EOF IOException message", (String)"Skip after end of file", (String)e.getMessage());
        }
    }

    private static final class TestNullInputStream
    extends NullInputStream {
        public TestNullInputStream(int size) {
            super((long)size);
        }

        public TestNullInputStream(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processByte() {
            return (int)this.getPosition() - 1;
        }

        protected void processBytes(byte[] bytes, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                bytes[i] = (byte)(startPos + i);
            }
        }
    }
}

