/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;

public class CountingOutputStreamTest
extends TestCase {
    public CountingOutputStreamTest(String name) {
        super(name);
    }

    public void testCounting() throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        for (int i2 = 0; i2 < 20; ++i2) {
            cos.write(i2);
        }
        this.assertByteArrayEquals("CountingOutputStream.write(int)", baos.toByteArray(), 0, 20);
        CountingOutputStreamTest.assertEquals((String)"CountingOutputStream.getCount()", (int)cos.getCount(), (int)20);
        byte[] array = new byte[10];
        for (i = 20; i < 30; ++i) {
            array[i - 20] = (byte)i;
        }
        cos.write(array);
        this.assertByteArrayEquals("CountingOutputStream.write(byte[])", baos.toByteArray(), 0, 30);
        CountingOutputStreamTest.assertEquals((String)"CountingOutputStream.getCount()", (int)cos.getCount(), (int)30);
        for (i = 25; i < 35; ++i) {
            array[i - 25] = (byte)i;
        }
        cos.write(array, 5, 5);
        this.assertByteArrayEquals("CountingOutputStream.write(byte[], int, int)", baos.toByteArray(), 0, 35);
        CountingOutputStreamTest.assertEquals((String)"CountingOutputStream.getCount()", (int)cos.getCount(), (int)35);
        int count = cos.resetCount();
        CountingOutputStreamTest.assertEquals((String)"CountingOutputStream.resetCount()", (int)count, (int)35);
        for (int i3 = 0; i3 < 10; ++i3) {
            cos.write(i3);
        }
        this.assertByteArrayEquals("CountingOutputStream.write(int)", baos.toByteArray(), 35, 45);
        CountingOutputStreamTest.assertEquals((String)"CountingOutputStream.getCount()", (int)cos.getCount(), (int)10);
    }

    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(size);
        NullOutputStream nos = new NullOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)nos);
        IOUtils.copyLarge((InputStream)mock, (OutputStream)cos);
        try {
            cos.getCount();
            CountingOutputStreamTest.fail((String)"Expected getCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException ae) {
            // empty catch block
        }
        try {
            cos.resetCount();
            CountingOutputStreamTest.fail((String)"Expected resetCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException ae) {
            // empty catch block
        }
        mock.close();
        IOUtils.copyLarge((InputStream)mock, (OutputStream)cos);
        CountingOutputStreamTest.assertEquals((String)"getByteCount()", (long)size, (long)cos.getByteCount());
        CountingOutputStreamTest.assertEquals((String)"resetByteCount()", (long)size, (long)cos.resetByteCount());
    }

    private void assertByteArrayEquals(String msg, byte[] array, int start, int end) {
        for (int i = start; i < end; ++i) {
            CountingOutputStreamTest.assertEquals((String)(msg + ": array[" + i + "] mismatch"), (int)array[i], (int)(i - start));
        }
    }
}

