/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class DeferredFileOutputStreamTest
extends TestCase {
    private String testString = "0123456789";
    private byte[] testBytes = this.testString.getBytes();

    public DeferredFileOutputStreamTest(String name) {
        super(name);
    }

    public void testBelowThreshold() {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, null);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertTrue((boolean)dfos.isInMemory());
        byte[] resultBytes = dfos.getData();
        DeferredFileOutputStreamTest.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
        DeferredFileOutputStreamTest.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
    }

    public void testAtThreshold() {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length, null);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertTrue((boolean)dfos.isInMemory());
        byte[] resultBytes = dfos.getData();
        DeferredFileOutputStreamTest.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
        DeferredFileOutputStreamTest.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
    }

    public void testAboveThreshold() {
        File testFile = new File("testAboveThreshold.dat");
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, testFile);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertFalse((boolean)dfos.isInMemory());
        DeferredFileOutputStreamTest.assertNull((Object)dfos.getData());
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    public void testThresholdReached() {
        File testFile = new File("testThresholdReached.dat");
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, testFile);
        int chunkSize = this.testBytes.length / 3;
        try {
            dfos.write(this.testBytes, 0, chunkSize);
            dfos.write(this.testBytes, chunkSize, chunkSize);
            dfos.write(this.testBytes, chunkSize * 2, this.testBytes.length - chunkSize * 2);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertFalse((boolean)dfos.isInMemory());
        DeferredFileOutputStreamTest.assertNull((Object)dfos.getData());
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    public void testWriteToSmall() {
        File testFile = new File("testWriteToMem.dat");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length * 2, testFile);
        try {
            dfos.write(this.testBytes);
            DeferredFileOutputStreamTest.assertFalse((boolean)testFile.exists());
            DeferredFileOutputStreamTest.assertTrue((boolean)dfos.isInMemory());
            try {
                dfos.writeTo((OutputStream)baos);
                DeferredFileOutputStreamTest.fail((String)"Should not have been able to write before closing");
            }
            catch (IOException ioe) {
                // empty catch block
            }
            dfos.close();
            dfos.writeTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        byte[] copiedBytes = baos.toByteArray();
        DeferredFileOutputStreamTest.assertTrue((boolean)Arrays.equals(this.testBytes, copiedBytes));
        testFile.delete();
    }

    public void testWriteToLarge() {
        File testFile = new File("testWriteToFile.dat");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, testFile);
        try {
            dfos.write(this.testBytes);
            DeferredFileOutputStreamTest.assertTrue((boolean)testFile.exists());
            DeferredFileOutputStreamTest.assertFalse((boolean)dfos.isInMemory());
            try {
                dfos.writeTo((OutputStream)baos);
                DeferredFileOutputStreamTest.fail((String)"Should not have been able to write before closeing");
            }
            catch (IOException ioe) {
                // empty catch block
            }
            dfos.close();
            dfos.writeTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        byte[] copiedBytes = baos.toByteArray();
        DeferredFileOutputStreamTest.assertTrue((boolean)Arrays.equals(this.testBytes, copiedBytes));
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    public void testTempFileBelowThreshold() {
        String prefix = "commons-io-test";
        String suffix = ".out";
        File tempDir = new File(".");
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, prefix, suffix, tempDir);
        DeferredFileOutputStreamTest.assertNull((String)"Check file is null-A", (Object)dfos.getFile());
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertTrue((boolean)dfos.isInMemory());
        DeferredFileOutputStreamTest.assertNull((String)"Check file is null-B", (Object)dfos.getFile());
    }

    public void testTempFileAboveThreshold() {
        String prefix = "commons-io-test";
        String suffix = ".out";
        File tempDir = new File(".");
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, prefix, suffix, tempDir);
        DeferredFileOutputStreamTest.assertNull((String)"Check file is null-A", (Object)dfos.getFile());
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertFalse((boolean)dfos.isInMemory());
        DeferredFileOutputStreamTest.assertNull((Object)dfos.getData());
        DeferredFileOutputStreamTest.assertNotNull((String)"Check file not null", (Object)dfos.getFile());
        DeferredFileOutputStreamTest.assertTrue((String)"Check file exists", (boolean)dfos.getFile().exists());
        DeferredFileOutputStreamTest.assertTrue((String)"Check prefix", (boolean)dfos.getFile().getName().startsWith(prefix));
        DeferredFileOutputStreamTest.assertTrue((String)"Check suffix", (boolean)dfos.getFile().getName().endsWith(suffix));
        DeferredFileOutputStreamTest.assertEquals((String)"Check dir", (String)tempDir.getPath(), (String)dfos.getFile().getParent());
        this.verifyResultFile(dfos.getFile());
        dfos.getFile().delete();
    }

    public void testTempFileAboveThresholdPrefixOnly() {
        String prefix = "commons-io-test";
        String suffix = null;
        File tempDir = null;
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, prefix, suffix, tempDir);
        DeferredFileOutputStreamTest.assertNull((String)"Check file is null-A", (Object)dfos.getFile());
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
        DeferredFileOutputStreamTest.assertFalse((boolean)dfos.isInMemory());
        DeferredFileOutputStreamTest.assertNull((Object)dfos.getData());
        DeferredFileOutputStreamTest.assertNotNull((String)"Check file not null", (Object)dfos.getFile());
        DeferredFileOutputStreamTest.assertTrue((String)"Check file exists", (boolean)dfos.getFile().exists());
        DeferredFileOutputStreamTest.assertTrue((String)"Check prefix", (boolean)dfos.getFile().getName().startsWith(prefix));
        DeferredFileOutputStreamTest.assertTrue((String)"Check suffix", (boolean)dfos.getFile().getName().endsWith(".tmp"));
        this.verifyResultFile(dfos.getFile());
        dfos.getFile().delete();
    }

    public void testTempFileError() {
        String prefix = null;
        String suffix = ".out";
        File tempDir = new File(".");
        try {
            new DeferredFileOutputStream(this.testBytes.length - 5, prefix, suffix, tempDir);
            DeferredFileOutputStreamTest.fail((String)"Expected IllegalArgumentException ");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void verifyResultFile(File testFile) {
        try {
            FileInputStream fis = new FileInputStream(testFile);
            DeferredFileOutputStreamTest.assertEquals((int)this.testBytes.length, (int)fis.available());
            byte[] resultBytes = new byte[this.testBytes.length];
            DeferredFileOutputStreamTest.assertEquals((int)this.testBytes.length, (int)fis.read(resultBytes));
            DeferredFileOutputStreamTest.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
            DeferredFileOutputStreamTest.assertEquals((int)-1, (int)fis.read(resultBytes));
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
        catch (FileNotFoundException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected FileNotFoundException");
        }
        catch (IOException e) {
            DeferredFileOutputStreamTest.fail((String)"Unexpected IOException");
        }
    }
}

