/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.output.StringBuilderWriter;

public class StringBuilderWriterTest
extends TestCase {
    private static final char[] FOOBAR_CHARS = new char[]{'F', 'o', 'o', 'B', 'a', 'r'};

    public StringBuilderWriterTest(String name) {
        super(name);
    }

    public void testAppendConstructCapacity() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(100);
        writer.append("Foo");
        StringBuilderWriterTest.assertEquals((String)"Foo", (String)writer.toString());
    }

    public void testAppendConstructStringBuilder() {
        StringBuilder builder = new StringBuilder("Foo");
        StringBuilderWriter writer = new StringBuilderWriter(builder);
        writer.append((CharSequence)"Bar");
        StringBuilderWriterTest.assertEquals((String)"FooBar", (String)writer.toString());
        StringBuilderWriterTest.assertSame((Object)builder, (Object)writer.getBuilder());
    }

    public void testAppendConstructNull() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter((StringBuilder)null);
        writer.append("Foo");
        StringBuilderWriterTest.assertEquals((String)"Foo", (String)writer.toString());
    }

    public void testAppendChar() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.append('F').append('o').append('o');
        StringBuilderWriterTest.assertEquals((String)"Foo", (String)writer.toString());
    }

    public void testAppendCharSequence() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.append("Foo").append("Bar");
        StringBuilderWriterTest.assertEquals((String)"FooBar", (String)writer.toString());
    }

    public void testAppendCharSequencePortion() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.append("FooBar", 3, 6).append(new StringBuffer("FooBar"), 0, 3);
        StringBuilderWriterTest.assertEquals((String)"BarFoo", (String)writer.toString());
    }

    public void testClose() {
        StringBuilderWriter writer = new StringBuilderWriter();
        try {
            writer.append("Foo");
            writer.close();
            writer.append("Bar");
        }
        catch (Throwable t) {
            StringBuilderWriterTest.fail((String)("Threw: " + t));
        }
        StringBuilderWriterTest.assertEquals((String)"FooBar", (String)writer.toString());
    }

    public void testWriteChar() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write(70);
        StringBuilderWriterTest.assertEquals((String)"F", (String)writer.toString());
        writer.write(111);
        StringBuilderWriterTest.assertEquals((String)"Fo", (String)writer.toString());
        writer.write(111);
        StringBuilderWriterTest.assertEquals((String)"Foo", (String)writer.toString());
    }

    public void testWriteCharArray() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write(new char[]{'F', 'o', 'o'});
        StringBuilderWriterTest.assertEquals((String)"Foo", (String)writer.toString());
        writer.write(new char[]{'B', 'a', 'r'});
        StringBuilderWriterTest.assertEquals((String)"FooBar", (String)writer.toString());
    }

    public void testWriteCharArrayPortion() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write(FOOBAR_CHARS, 3, 3);
        StringBuilderWriterTest.assertEquals((String)"Bar", (String)writer.toString());
        writer.write(FOOBAR_CHARS, 0, 3);
        StringBuilderWriterTest.assertEquals((String)"BarFoo", (String)writer.toString());
    }

    public void testWriteString() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write("Foo");
        StringBuilderWriterTest.assertEquals((String)"Foo", (String)writer.toString());
        writer.write("Bar");
        StringBuilderWriterTest.assertEquals((String)"FooBar", (String)writer.toString());
    }

    public void testWriteStringPortion() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write("FooBar", 3, 3);
        StringBuilderWriterTest.assertEquals((String)"Bar", (String)writer.toString());
        writer.write("FooBar", 0, 3);
        StringBuilderWriterTest.assertEquals((String)"BarFoo", (String)writer.toString());
    }
}

